/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.ltl.EquivalenceClass;
import owl.ltl.LtlLanguageExpressible;
import owl.translations.mastertheorem.AsymmetricEvaluatedFixpoints;

public final class AsymmetricProductState
implements LtlLanguageExpressible {
    public final AsymmetricEvaluatedFixpoints evaluatedFixpoints;
    public final int index;
    public final EquivalenceClass currentCoSafety;
    public final List<EquivalenceClass> nextCoSafety;
    public final EquivalenceClass safety;
    @Nullable
    public final AsymmetricEvaluatedFixpoints.DeterministicAutomata automata;
    private final EquivalenceClass precomputedLanguage;
    private final int precomputedHashCode;

    public AsymmetricProductState(int index, EquivalenceClass safety, EquivalenceClass currentCoSafety, List<EquivalenceClass> nextCoSafety, AsymmetricEvaluatedFixpoints evaluatedFixpoints, @Nullable AsymmetricEvaluatedFixpoints.DeterministicAutomata automata) {
        Preconditions.checkArgument((automata == null || 0 <= index && index < automata.coSafety.size() || index < 0 && -index <= automata.fCoSafety.size() || automata.coSafety.isEmpty() && automata.fCoSafety.isEmpty() && index == 0 ? 1 : 0) != 0);
        this.index = index;
        this.currentCoSafety = Objects.requireNonNull(currentCoSafety);
        this.evaluatedFixpoints = Objects.requireNonNull(evaluatedFixpoints);
        this.safety = Objects.requireNonNull(safety);
        this.nextCoSafety = List.copyOf(nextCoSafety);
        this.automata = automata;
        this.precomputedHashCode = Objects.hash(currentCoSafety, evaluatedFixpoints, safety, index, nextCoSafety);
        this.precomputedLanguage = Stream.concat(Stream.of(safety, currentCoSafety, evaluatedFixpoints.language()), nextCoSafety.stream()).reduce(EquivalenceClass::and).orElseThrow();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricProductState)) {
            return false;
        }
        AsymmetricProductState other = (AsymmetricProductState)o;
        return this.precomputedHashCode == other.precomputedHashCode && this.index == other.index && this.safety.equals(other.safety) && this.currentCoSafety.equals(other.currentCoSafety) && this.nextCoSafety.equals(other.nextCoSafety) && this.evaluatedFixpoints.equals(other.evaluatedFixpoints);
    }

    public int hashCode() {
        return this.precomputedHashCode;
    }

    @Override
    public EquivalenceClass language() {
        return this.precomputedLanguage;
    }

    public String toString() {
        String[] pieces = new String[]{this.safety.isTrue() ? null : "GWR=" + this.safety, this.index == 0 ? null : "i=" + this.index, this.currentCoSafety.isTrue() ? null : "C=" + this.currentCoSafety, this.nextCoSafety.isEmpty() ? null : "N=" + this.nextCoSafety};
        return this.evaluatedFixpoints + Arrays.stream(pieces).filter(Objects::nonNull).collect(Collectors.joining(", ", " [", "]"));
    }
}

