/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nba2ldba;

import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.determinization.Determinization;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.bdd.BddSet;
import owl.bdd.BddSetFactory;
import owl.bdd.MtBdd;
import owl.collections.BitSet2;
import owl.collections.Either;
import owl.translations.nba2ldba.BreakpointState;

public final class NBA2LDBA
implements Function<Automaton<?, ?>, Automaton<?, ? extends BuchiAcceptance>> {
    @Override
    public Automaton<?, ? extends BuchiAcceptance> apply(Automaton<?, ?> automaton) {
        return NBA2LDBA.applyLDBA(automaton).automaton();
    }

    public static AutomatonUtil.LimitDeterministicGeneralizedBuchiAutomaton<?, ? extends BuchiAcceptance> applyLDBA(Automaton<?, ?> automaton) {
        Automaton<?, BuchiAcceptance> nba;
        Optional<AutomatonUtil.LimitDeterministicGeneralizedBuchiAutomaton<?, BuchiAcceptance>> ldba;
        Automaton<Object, GeneralizedBuchiAcceptance> ngba = automaton.acceptance() instanceof AllAcceptance ? OmegaAcceptanceCast.cast(Determinization.determinizeAllAcceptance(OmegaAcceptanceCast.cast(automaton, AllAcceptance.class)), BuchiAcceptance.class) : OmegaAcceptanceCast.cast(automaton, GeneralizedBuchiAcceptance.class);
        if (automaton.acceptance() instanceof BuchiAcceptance && (ldba = AutomatonUtil.ldbaSplit(nba = OmegaAcceptanceCast.cast(ngba, BuchiAcceptance.class))).isPresent()) {
            return ldba.get();
        }
        MutableAutomaton ldba2 = MutableAutomatonUtil.asMutable(new BreakpointAutomaton(ngba));
        AcceptanceOptimizations.removeDeadStates(ldba2);
        return AutomatonUtil.LimitDeterministicGeneralizedBuchiAutomaton.of(ldba2, ldba2.states().stream().filter(x -> x.type() == Either.Type.LEFT).collect(Collectors.toSet()));
    }

    static final class BreakpointAutomaton<S>
    extends AbstractMemoizingAutomaton.PartitionedEdgeTreeImplementation<S, BreakpointState<S>, BuchiAcceptance> {
        private final Automaton<S, ? extends GeneralizedBuchiAcceptance> ngba;
        private final List<Set<S>> sccs;
        private final int acceptanceSets;

        BreakpointAutomaton(Automaton<S, ? extends GeneralizedBuchiAcceptance> ngba) {
            super(ngba.atomicPropositions(), ngba.factory(), ngba.initialStates(), Set.of(), BuchiAcceptance.INSTANCE);
            this.ngba = ngba;
            this.sccs = SccDecomposition.of(ngba).sccsWithoutTransient();
            this.acceptanceSets = Math.max(ngba.acceptance().acceptanceSets(), 1);
        }

        @Override
        protected MtBdd<Edge<S>> edgeTreeImplA(S state) {
            return this.ngba.edgeTree(state).map(x -> x.stream().map(Edge::withoutAcceptance).collect(Collectors.toUnmodifiableSet()));
        }

        @Override
        protected MtBdd<Edge<BreakpointState<S>>> edgeTreeImplB(BreakpointState<S> state) {
            BddSetFactory factory = this.factory();
            HashMap<Edge<BreakpointState<S>>, BddSet> labelledEdges = new HashMap<Edge<BreakpointState<S>>, BddSet>();
            int upTo = this.atomicPropositions.size();
            for (BitSet valuation : BitSet2.powerSet(upTo)) {
                for (Edge<BreakpointState<S>> edge : this.edgesB(state, valuation)) {
                    labelledEdges.merge(edge, factory.of(valuation, upTo), BddSet::union);
                }
            }
            return factory.toMtBdd(labelledEdges);
        }

        private Set<Edge<BreakpointState<S>>> edgesB(BreakpointState<S> ldbaState, BitSet valuation) {
            Set n1;
            int i1;
            Optional<Set> optionalScc = this.sccs.stream().filter(x -> x.containsAll(ldbaState.mx())).findAny();
            if (optionalScc.isEmpty()) {
                return Set.of();
            }
            Set scc = optionalScc.get();
            Set outEdgesM = ldbaState.mx().stream().flatMap(x -> this.ngba.edges(x, valuation).stream()).filter(x -> scc.contains(x.successor())).collect(Collectors.toSet());
            if (outEdgesM.isEmpty()) {
                return Set.of();
            }
            Set outEdgesN = ldbaState.nx().stream().flatMap(x -> this.ngba.edges(x, valuation).stream()).filter(x -> scc.contains(x.successor())).collect(Collectors.toSet());
            Set intersection = outEdgesM.stream().filter(x -> x.colours().contains(ldbaState.ix() % this.acceptanceSets)).collect(Collectors.toSet());
            outEdgesN.addAll(intersection);
            if (outEdgesM.equals(outEdgesN)) {
                i1 = (ldbaState.ix() + 1) % this.acceptanceSets;
                n1 = Edges.successors(Sets.filter(outEdgesM, x -> x.colours().contains(i1)));
            } else {
                i1 = ldbaState.ix();
                n1 = Edges.successors(outEdgesN);
            }
            BreakpointState successor = BreakpointState.of(i1, Edges.successors(outEdgesM), n1);
            return Set.of(i1 == 0 && outEdgesM.equals(outEdgesN) ? Edge.of(successor, 0) : Edge.of(successor));
        }

        @Override
        protected Set<BreakpointState<S>> moveAtoB(S state) {
            for (Set<S> scc : this.sccs) {
                if (!scc.contains(state)) continue;
                return Set.of(BreakpointState.of(0, Set.of(state), Set.of()));
            }
            return Set.of();
        }
    }
}

