/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.hoa.HoaWriter;
import owl.bdd.BddSet;
import owl.bdd.BddSetFactory;
import owl.bdd.EquivalenceClassFactory;
import owl.bdd.Factories;
import owl.bdd.FactorySupplier;
import owl.bdd.MtBdd;
import owl.collections.BitSet2;
import owl.collections.ImmutableBitSet;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.Converter;
import owl.ltl.visitors.UnabbreviateVisitor;
import owl.translations.rabinizer.GSet;
import owl.translations.rabinizer.MasterStatePartition;
import owl.translations.rabinizer.MonitorAutomaton;
import owl.translations.rabinizer.MonitorBuilder;
import owl.translations.rabinizer.MonitorState;
import owl.translations.rabinizer.NatCartesianProductIterator;
import owl.translations.rabinizer.RabinizerConfiguration;
import owl.translations.rabinizer.RabinizerProductEdge;
import owl.translations.rabinizer.RabinizerState;
import owl.translations.rabinizer.RabinizerStateFactory;

public final class RabinizerBuilder {
    private static final MonitorAutomaton[] EMPTY_MONITORS = new MonitorAutomaton[0];
    private static final Logger logger = Logger.getLogger(RabinizerBuilder.class.getName());
    private final RabinizerConfiguration configuration;
    private final EquivalenceClassFactory eqFactory;
    private final EquivalenceClass initialClass;
    private final RabinizerStateFactory.MasterStateFactory masterStateFactory;
    private final RabinizerStateFactory.ProductStateFactory productStateFactory;
    private final BddSetFactory vsFactory;

    private RabinizerBuilder(RabinizerConfiguration configuration, Factories factories, Formula formula) {
        EquivalenceClass initialClass = factories.eqFactory.of(formula);
        this.configuration = configuration;
        this.initialClass = initialClass;
        boolean fairnessFragment = configuration.eager() && initialClass.support(false).stream().allMatch(support -> SyntacticFragments.isInfinitelyOften(support) || SyntacticFragments.isAlmostAll(support));
        this.vsFactory = factories.vsFactory;
        this.eqFactory = factories.eqFactory;
        this.masterStateFactory = new RabinizerStateFactory.MasterStateFactory(configuration.eager(), fairnessFragment);
        this.productStateFactory = new RabinizerStateFactory.ProductStateFactory(configuration.eager());
    }

    private static BddSet[][] computeMonitorPriorities(MonitorAutomaton[] monitors, List<MonitorState> monitorStates, GSet activeSet) {
        int monitorCount = monitors.length;
        BddSet[][] monitorPriorities = new BddSet[monitorCount][];
        for (int relevantIndex = 0; relevantIndex < monitorStates.size(); ++relevantIndex) {
            MonitorState monitorState = monitorStates.get(relevantIndex);
            Automaton<MonitorState, ParityAcceptance> monitor = monitors[relevantIndex].getAutomaton(activeSet);
            int monitorAcceptanceSets = monitor.acceptance().acceptanceSets();
            BddSet[] edgePriorities = new BddSet[monitorAcceptanceSets];
            monitor.edgeMap(monitorState).forEach((edge, valuations) -> {
                ImmutableBitSet colours = edge.colours();
                OptionalInt priority = colours.first();
                if (priority.isEmpty()) {
                    return;
                }
                assert (priority.equals(colours.last()));
                edgePriorities[priority.getAsInt()] = edgePriorities[priority.getAsInt()] == null ? valuations : valuations.union(edgePriorities[priority.getAsInt()]);
            });
            monitorPriorities[relevantIndex] = edgePriorities;
        }
        return monitorPriorities;
    }

    private static boolean isSuspendableScc(Set<EquivalenceClass> scc, Set<GOperator> relevantOperators) {
        BitSet internalAtoms = new BitSet();
        relevantOperators.forEach(x1 -> internalAtoms.or(x1.atomicPropositions(true)));
        for (EquivalenceClass state : scc) {
            EvaluateVisitor visitor = new EvaluateVisitor(relevantOperators, state);
            EquivalenceClass substitute = state.substitute(visitor);
            BitSet externalAtoms = substitute.atomicPropositions(false);
            substitute.temporalOperators().forEach(x -> externalAtoms.or(x.atomicPropositions(true)));
            if (!externalAtoms.isEmpty() && !externalAtoms.intersects(internalAtoms)) continue;
            return false;
        }
        return true;
    }

    private static String printOperatorSets(ActiveSet[] activeSets) {
        StringBuilder tableBuilder = new StringBuilder(60 + activeSets.length * 20);
        tableBuilder.append("Acceptance mapping (GSet -> Ranking -> Pair):");
        for (ActiveSet activeSet : activeSets) {
            GSet subset = activeSet.set;
            tableBuilder.append("\n ").append(subset);
            Iterator<List<Integer>> rankingIterator = activeSet.rankings.iterator();
            int index = 0;
            while (rankingIterator.hasNext()) {
                GeneralizedRabinAcceptance.RabinPair pair = activeSet.getPairForRanking(index);
                tableBuilder.append("\n  ").append(rankingIterator.next()).append(" -> ").append(pair);
                ++index;
            }
        }
        return tableBuilder.toString();
    }

    public static MutableAutomaton<RabinizerState, GeneralizedRabinAcceptance> build(LabelledFormula formula, RabinizerConfiguration configuration) {
        Factories factories = FactorySupplier.defaultSupplier().getFactories(formula.atomicPropositions());
        Formula phiNormalized = formula.formula().nnf().accept(new UnabbreviateVisitor(WOperator.class, ROperator.class));
        logger.log(Level.FINE, "Creating rabinizer automaton for formula {0}", LabelledFormula.of(phiNormalized, formula.atomicPropositions()).toString());
        MutableAutomaton<RabinizerState, GeneralizedRabinAcceptance> automaton = new RabinizerBuilder(configuration, factories, phiNormalized).build();
        automaton.trim();
        return automaton;
    }

    private MutableAutomaton<RabinizerState, GeneralizedRabinAcceptance> build() {
        AbstractMemoizingAutomaton.EdgeTreeImplementation<EquivalenceClass, AllAcceptance> masterAutomaton = new AbstractMemoizingAutomaton.EdgeTreeImplementation<EquivalenceClass, AllAcceptance>(this.eqFactory.atomicPropositions(), this.vsFactory, Set.of(this.masterStateFactory.initialState(this.initialClass)), AllAcceptance.INSTANCE){

            @Override
            protected MtBdd<Edge<EquivalenceClass>> edgeTreeImpl(EquivalenceClass state) {
                return RabinizerBuilder.this.masterStateFactory.edgeTree(state);
            }
        };
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Master automaton for {0}:\n{1}", new Object[]{this.initialClass, HoaWriter.toString(masterAutomaton)});
        } else {
            logger.log(Level.FINE, "Master automaton for {0} has {1} states", new Object[]{this.initialClass, masterAutomaton.states().size()});
        }
        MasterStatePartition masterSccPartition = MasterStatePartition.create(masterAutomaton);
        logger.log(Level.FINER, masterSccPartition::toString);
        int partitionSize = masterSccPartition.sccs.size();
        Set[] sccRelevantGList = new Set[partitionSize];
        int s = masterSccPartition.sccs.size();
        for (int i = 0; i < s; ++i) {
            sccRelevantGList[i] = masterSccPartition.sccs.get(i).stream().map(this::relevantSubFormulas).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        }
        Set allRelevantGFormulas = Arrays.stream(sccRelevantGList).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        logger.log(Level.FINE, "Identified relevant sub-formulas: {0}", allRelevantGFormulas);
        GOperator[] gFormulas = (GOperator[])allRelevantGFormulas.toArray(GOperator[]::new);
        MonitorAutomaton[] monitors = new MonitorAutomaton[gFormulas.length];
        Arrays.setAll(monitors, gIndex -> this.buildMonitor(gFormulas[gIndex]));
        GeneralizedRabinAcceptance.Builder builder = new GeneralizedRabinAcceptance.Builder();
        Set relevantSets = Sets.powerSet(allRelevantGFormulas);
        assert (relevantSets.contains(Set.of()));
        int gSetCount = relevantSets.size() - 1;
        ActiveSet[] activeSets = new ActiveSet[gSetCount];
        int activeSetIndex = 0;
        for (Set subset : relevantSets) {
            if (subset.isEmpty()) continue;
            GSet gSet = new GSet(subset, this.eqFactory);
            activeSets[activeSetIndex] = ActiveSet.create(gFormulas, gSet, monitors, builder);
            ++activeSetIndex;
        }
        HashMapAutomaton<RabinizerState, GeneralizedRabinAcceptance> rabinizerAutomaton = HashMapAutomaton.create(this.eqFactory.atomicPropositions(), this.vsFactory, builder.build());
        List<Set<EquivalenceClass>> partition = masterSccPartition.sccs;
        HashMultimap statesPerClass = HashMultimap.create();
        for (int sccIndex = 0; sccIndex < partition.size(); ++sccIndex) {
            BitSet relevantFormulas;
            MonitorAutomaton[] sccMonitors;
            boolean suspendable;
            Set<EquivalenceClass> scc = partition.get(sccIndex);
            Set sccRelevantOperators = sccRelevantGList[sccIndex];
            boolean bl = suspendable = this.configuration.suspendableFormulaDetection() && RabinizerBuilder.isSuspendableScc(scc, sccRelevantOperators);
            if (suspendable) {
                sccMonitors = EMPTY_MONITORS;
                relevantFormulas = new BitSet();
                logger.log(Level.FINE, "Suspending all Gs on SCC {0}", sccIndex);
            } else {
                relevantFormulas = new BitSet();
                sccMonitors = new MonitorAutomaton[sccRelevantOperators.size()];
                int subsetRelevantIndex = 0;
                for (int gIndex2 = 0; gIndex2 < gFormulas.length; ++gIndex2) {
                    boolean indexRelevant = sccRelevantOperators.contains(gFormulas[gIndex2]);
                    relevantFormulas.set(gIndex2, indexRelevant);
                    if (!indexRelevant) continue;
                    sccMonitors[subsetRelevantIndex] = monitors[gIndex2];
                    ++subsetRelevantIndex;
                }
                logger.log(Level.FINE, "Building product of SCC {0}, size: {1}, formulas: {2}", new Object[]{sccIndex, scc.size(), sccRelevantOperators});
            }
            Map<RabinizerState, Map<RabinizerProductEdge, BddSet>> transitionSystem = this.exploreTransitionSystem(scc, masterAutomaton, sccMonitors);
            if (sccRelevantOperators.isEmpty()) {
                transitionSystem.forEach((arg_0, arg_1) -> this.lambda$build$6((Multimap)statesPerClass, rabinizerAutomaton, arg_0, arg_1));
                continue;
            }
            logger.log(Level.FINER, "Computing acceptance on SCC {0}", sccIndex);
            transitionSystem.forEach((arg_0, arg_1) -> this.lambda$build$10(relevantFormulas, activeSets, sccMonitors, (Multimap)statesPerClass, rabinizerAutomaton, arg_0, arg_1));
        }
        logger.log(Level.FINE, "Connecting the SCCs");
        masterSccPartition.transientStates.forEach(arg_0 -> RabinizerBuilder.lambda$build$11((Multimap)statesPerClass, arg_0));
        Function<EquivalenceClass, RabinizerState> getAnyState = arg_0 -> RabinizerBuilder.lambda$build$12(masterSccPartition, (Multimap)statesPerClass, arg_0);
        masterSccPartition.outgoingTransitions.rowMap().forEach((arg_0, arg_1) -> RabinizerBuilder.lambda$build$14((Multimap)statesPerClass, getAnyState, rabinizerAutomaton, arg_0, arg_1));
        rabinizerAutomaton.initialStates(Set.of(getAnyState.apply(this.masterStateFactory.initialState(this.initialClass))));
        rabinizerAutomaton.trim();
        RabinizerState trueState = RabinizerState.of(this.eqFactory.of(BooleanConstant.TRUE), List.of());
        if (rabinizerAutomaton.states().contains(trueState)) {
            assert (Objects.equals(Iterables.getOnlyElement(rabinizerAutomaton.successors(trueState)), trueState));
            GeneralizedRabinAcceptance.RabinPair truePair = builder.add(1);
            rabinizerAutomaton.removeEdge(trueState, rabinizerAutomaton.factory().of(true), trueState);
            rabinizerAutomaton.addEdge(trueState, this.vsFactory.of(true), Edge.of(trueState, truePair.infSet()));
            rabinizerAutomaton.acceptance(builder.build());
            rabinizerAutomaton.trim();
        }
        logger.log(Level.FINER, () -> String.format("Result:%n%s", HoaWriter.toString(rabinizerAutomaton)));
        logger.log(Level.FINER, () -> RabinizerBuilder.printOperatorSets(activeSets));
        return rabinizerAutomaton;
    }

    private MonitorAutomaton buildMonitor(GOperator gOperator) {
        logger.log(Level.FINE, "Building monitor for sub-formula {0}", gOperator);
        EquivalenceClass operand = this.eqFactory.of(gOperator.operand());
        Set<GOperator> relevantOperators = this.relevantSubFormulas(operand);
        Set powerSets = Sets.powerSet(relevantOperators);
        ArrayList<GSet> relevantGSets = new ArrayList<GSet>(powerSets.size());
        powerSets.forEach(gSet -> relevantGSets.add(new GSet((Collection<GOperator>)gSet, this.eqFactory)));
        MonitorAutomaton monitor = MonitorBuilder.create(gOperator, operand, relevantGSets, this.vsFactory, this.configuration.eager());
        logger.log(Level.FINER, () -> String.format("Monitor for %s:%n%s", gOperator, HoaWriter.toString(monitor)));
        if (logger.isLoggable(Level.FINEST)) {
            monitor.getAutomata().forEach((set, automaton) -> logger.log(Level.FINEST, "For set {0}\n{1}", new Object[]{set, HoaWriter.toString(automaton)}));
        }
        return monitor;
    }

    private void createEdges(RabinizerState state, Map<RabinizerProductEdge, BddSet> successors, MutableAutomaton<RabinizerState, ?> rabinizerAutomaton) {
        rabinizerAutomaton.addState(state);
        BitSet sensitiveAlphabet = this.productStateFactory.getSensitiveAlphabet(state);
        successors.forEach((cache, valuations) -> {
            RabinizerState rabinizerSuccessor = cache.getRabinizerSuccessor();
            BddSet[] acceptanceCache = cache.getSuccessorAcceptance();
            for (BitSet valuation : BitSet2.powerSet(sensitiveAlphabet)) {
                if (!valuations.contains(valuation)) continue;
                int acceptanceIndices = acceptanceCache.length;
                BitSet edgeAcceptanceSet = new BitSet(acceptanceIndices);
                for (int acceptanceIndex = 0; acceptanceIndex < acceptanceIndices; ++acceptanceIndex) {
                    BddSet acceptanceValuations = acceptanceCache[acceptanceIndex];
                    if (acceptanceValuations == null || !acceptanceValuations.contains(valuation)) continue;
                    edgeAcceptanceSet.set(acceptanceIndex);
                }
                Edge<RabinizerState> rabinizerEdge = Edge.of(rabinizerSuccessor, edgeAcceptanceSet);
                BddSet edgeValuation = this.vsFactory.of(valuation, sensitiveAlphabet);
                rabinizerAutomaton.addEdge(state, edgeValuation, rabinizerEdge);
            }
        });
    }

    private Map<RabinizerState, Map<RabinizerProductEdge, BddSet>> exploreTransitionSystem(Set<EquivalenceClass> stateSubset, Automaton<EquivalenceClass, ?> masterAutomaton, MonitorAutomaton[] monitors) {
        int relevantFormulaCount = monitors.length;
        EquivalenceClass masterInitialState = stateSubset.iterator().next();
        MonitorState[] monitorInitialStates = new MonitorState[relevantFormulaCount];
        Arrays.setAll(monitorInitialStates, i -> (MonitorState)monitors[i].initialState());
        RabinizerState initialState = RabinizerState.of(masterInitialState, monitorInitialStates);
        HashMap<RabinizerState, Map<RabinizerProductEdge, BddSet>> transitionSystem = new HashMap<RabinizerState, Map<RabinizerProductEdge, BddSet>>();
        HashSet exploredStates = Sets.newHashSet((Object[])new RabinizerState[]{initialState});
        ArrayDeque<RabinizerState> workQueue = new ArrayDeque<RabinizerState>(exploredStates);
        while (!workQueue.isEmpty()) {
            RabinizerState currentState = (RabinizerState)workQueue.remove();
            logger.log(Level.FINEST, "Exploring {0}", currentState);
            assert (currentState.monitorStates().size() == relevantFormulaCount);
            assert (!transitionSystem.containsKey(currentState));
            EquivalenceClass masterState = currentState.masterState();
            List<MonitorState> monitorStates = currentState.monitorStates();
            Set<EquivalenceClass> masterSuccessors = masterAutomaton.successors(masterState);
            if (masterSuccessors.isEmpty()) {
                transitionSystem.put(currentState, Map.of());
                continue;
            }
            HashMap<RabinizerProductEdge, BddSet> rabinizerSuccessors = new HashMap<RabinizerProductEdge, BddSet>();
            transitionSystem.put(currentState, rabinizerSuccessors);
            MonitorState[][] monitorSuccessorMatrix = new MonitorState[relevantFormulaCount][];
            BddSet[][] monitorValuationMatrix = new BddSet[relevantFormulaCount][];
            int[] successorCounts = new int[relevantFormulaCount];
            for (int monitorIndex = 0; monitorIndex < relevantFormulaCount; ++monitorIndex) {
                MonitorState monitorState = monitorStates.get(monitorIndex);
                HashMap successors = new HashMap();
                monitors[monitorIndex].edgeMap(monitorState).forEach((edge, valuations) -> successors.merge((MonitorState)edge.successor(), valuations, BddSet::union));
                int monitorSuccessorCount = successors.size();
                successorCounts[monitorIndex] = monitorSuccessorCount - 1;
                MonitorState[] successorStates = new MonitorState[monitorSuccessorCount];
                BddSet[] successorValuations = new BddSet[monitorSuccessorCount];
                int index = 0;
                for (Map.Entry element : successors.entrySet()) {
                    successorStates[index] = (MonitorState)element.getKey();
                    successorValuations[index] = (BddSet)element.getValue();
                    ++index;
                }
                monitorSuccessorMatrix[monitorIndex] = successorStates;
                monitorValuationMatrix[monitorIndex] = successorValuations;
            }
            BitSet sensitiveAlphabet = this.productStateFactory.getSensitiveAlphabet(currentState);
            long powerSetSize = 1L << sensitiveAlphabet.size() + 2;
            long totalSuccessorCounts = (long)masterSuccessors.size() * NatCartesianProductIterator.numberOfElements(successorCounts);
            if (totalSuccessorCounts > 1L << (int)(powerSetSize + 2L)) {
                for (BitSet valuation : BitSet2.powerSet(sensitiveAlphabet)) {
                    EquivalenceClass masterSuccessor;
                    Edge<EquivalenceClass> masterEdge = masterAutomaton.edge(masterState, valuation);
                    if (masterEdge == null || !stateSubset.contains(masterSuccessor = masterEdge.successor())) continue;
                    MonitorState[] monitorSuccessors = new MonitorState[monitorStates.size()];
                    Arrays.setAll(monitorSuccessors, relevantIndex -> {
                        MonitorState currentMonitorState = (MonitorState)monitorStates.get(relevantIndex);
                        MonitorAutomaton monitor = monitors[relevantIndex];
                        return monitor.successor(currentMonitorState, valuation);
                    });
                    RabinizerState rabinizerSuccessor = RabinizerState.of(masterSuccessor, monitorSuccessors);
                    rabinizerSuccessors.merge(new RabinizerProductEdge(rabinizerSuccessor), this.vsFactory.of(valuation, sensitiveAlphabet), BddSet::union);
                    if (!exploredStates.add(rabinizerSuccessor)) continue;
                    workQueue.add(rabinizerSuccessor);
                }
                continue;
            }
            masterAutomaton.edgeMap(masterState).forEach((edge, valuationSet) -> {
                if (!stateSubset.contains(edge.successor())) {
                    return;
                }
                NatCartesianProductIterator productIterator = new NatCartesianProductIterator(successorCounts);
                block0: while (productIterator.hasNext()) {
                    int[] successorSelection = productIterator.next();
                    BddSet productValuation = valuationSet;
                    MonitorState[] monitorSuccessors = new MonitorState[monitorStates.size()];
                    for (int monitorIndex = 0; monitorIndex < relevantFormulaCount; ++monitorIndex) {
                        MonitorState currentMonitorState = (MonitorState)monitorStates.get(monitorIndex);
                        assert (currentMonitorState != null);
                        int monitorMatrixIndex = successorSelection[monitorIndex];
                        monitorSuccessors[monitorIndex] = monitorSuccessorMatrix[monitorIndex][monitorMatrixIndex];
                        BddSet monitorSuccessorValuation = monitorValuationMatrix[monitorIndex][monitorMatrixIndex];
                        if ((productValuation = productValuation.intersection(monitorSuccessorValuation)).isEmpty()) continue block0;
                    }
                    RabinizerState successor = RabinizerState.of((EquivalenceClass)edge.successor(), monitorSuccessors);
                    rabinizerSuccessors.merge(new RabinizerProductEdge(successor), productValuation, BddSet::union);
                    if (!exploredStates.add(successor)) continue;
                    workQueue.add(successor);
                }
            });
        }
        return transitionSystem;
    }

    private static void findSupportingSubFormulas(EquivalenceClass equivalenceClass, Set<GOperator> gOperators) {
        for (Formula.TemporalOperator temporalOperator : equivalenceClass.temporalOperators()) {
            if (temporalOperator instanceof GOperator) {
                gOperators.add((GOperator)temporalOperator);
                continue;
            }
            Formula unwrapped = temporalOperator;
            while (unwrapped instanceof Formula.UnaryTemporalOperator && !((unwrapped = ((Formula.UnaryTemporalOperator)unwrapped).operand()) instanceof GOperator)) {
            }
            EquivalenceClassFactory factory = equivalenceClass.factory();
            if (unwrapped instanceof GOperator) {
                gOperators.add((GOperator)unwrapped);
                continue;
            }
            if (unwrapped instanceof Formula.BinaryTemporalOperator) {
                Formula.BinaryTemporalOperator binaryOperator = (Formula.BinaryTemporalOperator)unwrapped;
                RabinizerBuilder.findSupportingSubFormulas(factory.of(binaryOperator.leftOperand()), gOperators);
                RabinizerBuilder.findSupportingSubFormulas(factory.of(binaryOperator.rightOperand()), gOperators);
                continue;
            }
            RabinizerBuilder.findSupportingSubFormulas(factory.of(unwrapped), gOperators);
        }
    }

    private Set<GOperator> relevantSubFormulas(EquivalenceClass clazz) {
        if (clazz.isTrue() || clazz.isFalse()) {
            return Set.of();
        }
        HashSet<GOperator> operators = new HashSet<GOperator>();
        if (this.configuration.supportBasedRelevantFormulaAnalysis()) {
            RabinizerBuilder.findSupportingSubFormulas(clazz, operators);
        } else {
            clazz.temporalOperators().forEach(x -> operators.addAll(x.subformulas(GOperator.class)));
        }
        return operators;
    }

    private static /* synthetic */ void lambda$build$14(Multimap statesPerClass, Function getAnyState, MutableAutomaton rabinizerAutomaton, EquivalenceClass masterState, Map masterSuccessors) {
        assert (!masterSuccessors.isEmpty());
        Collection rabinizerStates = statesPerClass.get((Object)masterState);
        masterSuccessors.forEach((masterSuccessor, valuations) -> {
            assert (!masterSuccessor.isFalse());
            Edge<RabinizerState> edge = Edge.of((RabinizerState)getAnyState.apply(masterSuccessor));
            for (RabinizerState state : rabinizerStates) {
                rabinizerAutomaton.addState(state);
                rabinizerAutomaton.addEdge(state, (BddSet)valuations, edge);
            }
        });
    }

    private static /* synthetic */ RabinizerState lambda$build$12(MasterStatePartition masterSccPartition, Multimap statesPerClass, EquivalenceClass masterState) {
        return masterSccPartition.transientStates.contains(masterState) ? RabinizerState.of(masterState, List.of()) : (RabinizerState)statesPerClass.get((Object)masterState).iterator().next();
    }

    private static /* synthetic */ void lambda$build$11(Multimap statesPerClass, EquivalenceClass state) {
        statesPerClass.put((Object)state, (Object)RabinizerState.of(state, List.of()));
    }

    private /* synthetic */ void lambda$build$10(BitSet relevantFormulas, ActiveSet[] activeSets, MonitorAutomaton[] sccMonitors, Multimap statesPerClass, MutableAutomaton rabinizerAutomaton, RabinizerState state, Map successors) {
        Set<GOperator> stateRelevantSubFormulas = this.relevantSubFormulas(state.masterState());
        logger.log(Level.FINEST, "Product transitions for {0}: {1}; relevant formulas: {2}", new Object[]{state, successors, stateRelevantSubFormulas});
        BitSet sensitiveAlphabet = this.productStateFactory.getSensitiveAlphabet(state);
        Iterator<BitSet> activeSubFormulasIterator = BitSet2.powerSet(relevantFormulas).iterator();
        activeSubFormulasIterator.next();
        while (activeSubFormulasIterator.hasNext()) {
            BitSet activeSubFormulas = activeSubFormulasIterator.next();
            ActiveSet activeSet = activeSets[BitSet2.toInt(activeSubFormulas) - 1];
            GSet activeSubFormulasSet = activeSet.set;
            BddSet[][] monitorPriorities = RabinizerBuilder.computeMonitorPriorities(sccMonitors, state.monitorStates(), activeSubFormulasSet);
            Iterator<List<Integer>> rankingIterator = activeSet.rankings.iterator();
            int rankingIndex = -1;
            while (rankingIterator.hasNext()) {
                List<Integer> ranking = rankingIterator.next();
                GeneralizedRabinAcceptance.RabinPair pair = activeSet.getPairForRanking(++rankingIndex);
                GSetRanking rankingPair = new GSetRanking(relevantFormulas, activeSubFormulas, activeSubFormulasSet, pair, ranking, this.eqFactory, monitorPriorities);
                if (!this.configuration.eager() && !rankingPair.monitorsEntail(state)) {
                    int finiteIndex = pair.finSet();
                    successors.forEach((transition, valuations) -> transition.addAcceptance((BddSet)valuations, finiteIndex));
                    continue;
                }
                successors.forEach((transition, valuations) -> {
                    for (BitSet valuation : BitSet2.powerSet(sensitiveAlphabet)) {
                        if (!valuations.contains(valuation)) continue;
                        BddSet edgeValuation = this.vsFactory.of(valuation, sensitiveAlphabet);
                        if (this.configuration.eager() && !rankingPair.monitorsEntailEager(state, valuation)) {
                            transition.addAcceptance(edgeValuation, pair.finSet());
                            continue;
                        }
                        rankingPair.getAcceptance(valuation).stream().forEach(acceptance -> transition.addAcceptance(edgeValuation, acceptance));
                    }
                });
            }
        }
        statesPerClass.put((Object)state.masterState(), (Object)state);
        this.createEdges(state, successors, rabinizerAutomaton);
        successors.clear();
    }

    private /* synthetic */ void lambda$build$6(Multimap statesPerClass, MutableAutomaton rabinizerAutomaton, RabinizerState state, Map successors) {
        statesPerClass.put((Object)state.masterState(), (Object)state);
        this.createEdges(state, successors, rabinizerAutomaton);
    }

    static final class EvaluateVisitor
    extends Converter {
        private final EquivalenceClass environment;
        private final EquivalenceClassFactory factory;

        EvaluateVisitor(Collection<GOperator> gMonitors, EquivalenceClass label) {
            super(SyntacticFragment.FGMU);
            this.factory = label.factory();
            this.environment = label.and(this.factory.of(Conjunction.of(Stream.concat(gMonitors.stream(), gMonitors.stream().map(Formula.UnaryTemporalOperator::operand)))));
        }

        private boolean isImplied(Formula formula) {
            return this.environment.implies(this.factory.of(formula));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            if (this.isImplied(disjunction)) {
                return BooleanConstant.TRUE;
            }
            return Disjunction.of(disjunction.map(e -> e.accept(this)));
        }

        @Override
        public Formula visit(FOperator fOperator) {
            if (this.isImplied(fOperator)) {
                return BooleanConstant.TRUE;
            }
            return FOperator.of(fOperator.operand().accept(this));
        }

        @Override
        public Formula visit(GOperator gOperator) {
            if (this.isImplied(gOperator)) {
                return BooleanConstant.TRUE;
            }
            return BooleanConstant.of(gOperator.operand().accept(this).equals(BooleanConstant.TRUE));
        }

        @Override
        public Formula visit(Literal literal) {
            return this.isImplied(literal) ? BooleanConstant.TRUE : literal;
        }

        @Override
        public Formula visit(MOperator mOperator) {
            if (this.isImplied(mOperator)) {
                return BooleanConstant.TRUE;
            }
            return MOperator.of(mOperator.leftOperand().accept(this), mOperator.rightOperand().accept(this));
        }

        @Override
        public Formula visit(UOperator uOperator) {
            if (this.isImplied(uOperator)) {
                return BooleanConstant.TRUE;
            }
            return UOperator.of(uOperator.leftOperand().accept(this), uOperator.rightOperand().accept(this));
        }

        @Override
        public Formula visit(XOperator xOperator) {
            if (this.isImplied(xOperator)) {
                return BooleanConstant.TRUE;
            }
            return XOperator.of(xOperator.operand().accept(this));
        }
    }

    private static final class GSetRanking {
        final GSet activeFormulaSet;
        final GeneralizedRabinAcceptance.RabinPair pair;
        final List<Integer> ranking;
        private final BitSet activeFormulas;
        private final EquivalenceClassFactory eqFactory;
        private final BddSet[][] monitorPriorities;
        private final BitSet relevantFormulas;

        GSetRanking(BitSet relevantFormulas, BitSet activeFormulas, GSet activeFormulaSet, GeneralizedRabinAcceptance.RabinPair pair, List<Integer> ranking, EquivalenceClassFactory eqFactory, BddSet[][] monitorPriorities) {
            assert (activeFormulas.length() <= relevantFormulas.length());
            this.activeFormulaSet = activeFormulaSet;
            this.pair = pair;
            this.ranking = ranking;
            this.eqFactory = eqFactory;
            this.monitorPriorities = monitorPriorities;
            this.activeFormulas = activeFormulas;
            this.relevantFormulas = relevantFormulas;
        }

        BitSet getAcceptance(BitSet valuation) {
            BitSet edgeAcceptanceSet = new BitSet();
            int relevantIndex = -1;
            int activeIndex = -1;
            for (int gIndex = 0; gIndex < this.activeFormulas.length(); ++gIndex) {
                if (!this.relevantFormulas.get(gIndex)) continue;
                ++relevantIndex;
                if (!this.activeFormulas.get(gIndex)) continue;
                ++activeIndex;
                int priority = -1;
                BddSet[] monitorEdgePriorities = this.monitorPriorities[relevantIndex];
                for (int i = 0; i < monitorEdgePriorities.length; ++i) {
                    BddSet priorityValuation = monitorEdgePriorities[i];
                    if (priorityValuation == null || !priorityValuation.contains(valuation)) continue;
                    priority = i;
                    break;
                }
                if (priority == -1) continue;
                if (priority == 0) {
                    edgeAcceptanceSet.set(this.pair.finSet());
                    return edgeAcceptanceSet;
                }
                int succeedPriority = 2 * this.ranking.get(activeIndex) + 1;
                if (priority > succeedPriority) continue;
                if (priority % 2 == 0) {
                    edgeAcceptanceSet.set(this.pair.finSet());
                    return edgeAcceptanceSet;
                }
                if (priority != succeedPriority) continue;
                edgeAcceptanceSet.set(this.pair.infSet(activeIndex));
            }
            return edgeAcceptanceSet;
        }

        boolean monitorsEntail(RabinizerState state) {
            return this.monitorsEntail(state.monitorStates(), null, state.masterState());
        }

        private boolean monitorsEntail(List<MonitorState> monitorStates, @Nullable BitSet valuation, EquivalenceClass consequent) {
            boolean eager = valuation != null;
            AtomicReference<EquivalenceClass> antecedent = new AtomicReference<EquivalenceClass>(this.eqFactory.of(BooleanConstant.TRUE));
            int relevantIndex2 = -1;
            int activeIndex2 = -1;
            for (int gIndex1 = 0; gIndex1 < this.activeFormulas.length(); ++gIndex1) {
                int rank;
                if (!this.relevantFormulas.get(gIndex1)) continue;
                ++relevantIndex2;
                if (!this.activeFormulas.get(gIndex1)) continue;
                MonitorState monitorState = monitorStates.get(relevantIndex2);
                List<EquivalenceClass> monitorStateRanking = monitorState.formulaRanking();
                for (int stateIndex = rank = this.ranking.get(++activeIndex2).intValue(); stateIndex < monitorStateRanking.size(); ++stateIndex) {
                    EquivalenceClass rankEntry = monitorStateRanking.get(stateIndex);
                    EquivalenceClass state = eager ? rankEntry.temporalStep(valuation) : rankEntry;
                    antecedent.updateAndGet(clazz -> clazz.and(state));
                }
            }
            if (eager) {
                antecedent.updateAndGet(clazz -> clazz.and(this.activeFormulaSet.operatorConjunction()));
            }
            Function<Formula, Formula> strengthening = formula -> formula instanceof GOperator ? BooleanConstant.of(this.activeFormulaSet.contains(formula)) : formula;
            EquivalenceClass strengthenedAntecedent = antecedent.get().substitute(strengthening);
            Function<Formula, Formula> weakening = formula -> formula instanceof GOperator && this.activeFormulaSet.contains(formula) ? BooleanConstant.TRUE : formula;
            EquivalenceClass testedConsequent = eager ? consequent.temporalStep(valuation) : consequent;
            EquivalenceClass weakenedConsequent = testedConsequent.substitute(weakening);
            boolean result = strengthenedAntecedent.implies(weakenedConsequent);
            if (logger.isLoggable(Level.FINEST)) {
                ArrayList<EquivalenceClass> activeMonitorStates = new ArrayList<EquivalenceClass>(this.activeFormulaSet.size());
                int relevantIndex1 = -1;
                int activeIndex1 = -1;
                for (int gIndex = 0; gIndex < this.activeFormulas.length(); ++gIndex) {
                    int size;
                    int rank;
                    if (!this.relevantFormulas.get(gIndex)) continue;
                    ++relevantIndex1;
                    if (!this.activeFormulas.get(gIndex)) continue;
                    List<EquivalenceClass> monitorStateRanking = monitorStates.get(relevantIndex1).formulaRanking();
                    if ((rank = this.ranking.get(++activeIndex1).intValue()) > (size = monitorStateRanking.size())) continue;
                    activeMonitorStates.addAll(monitorStateRanking.subList(rank, size));
                }
                String rankingString = this.ranking.toString();
                String log = String.format("Subset %s, ranking %s, and monitor states %s (strengthened: %s), valuation %s; entails %s (weakened: %s): %s", this.activeFormulaSet, rankingString, activeMonitorStates, strengthenedAntecedent, valuation, consequent, weakenedConsequent, result);
                logger.log(Level.FINEST, log);
            }
            return result;
        }

        boolean monitorsEntailEager(RabinizerState state, BitSet valuation) {
            return this.monitorsEntail(state.monitorStates(), valuation, state.masterState());
        }
    }

    private static final class ActiveSet {
        final GSet set;
        final List<List<Integer>> rankings;
        private final GeneralizedRabinAcceptance.RabinPair[] rankingPairs;

        ActiveSet(GSet set, List<List<Integer>> rankings, GeneralizedRabinAcceptance.RabinPair[] rankingPairs) {
            this.set = set;
            this.rankings = rankings;
            this.rankingPairs = rankingPairs;
        }

        static ActiveSet create(GOperator[] operators, GSet subset, MonitorAutomaton[] monitors, GeneralizedRabinAcceptance.Builder builder) {
            int gCount = operators.length;
            int[] maximalRanks = new int[subset.size()];
            int relevantIndex = 0;
            for (int gIndex = 0; gIndex < gCount; ++gIndex) {
                if (!subset.contains(operators[gIndex])) continue;
                MonitorAutomaton monitor = monitors[gIndex];
                Automaton<MonitorState, ParityAcceptance> gSetMonitor = monitor.getAutomaton(subset);
                int acceptanceSets = gSetMonitor.acceptance().acceptanceSets();
                maximalRanks[relevantIndex] = acceptanceSets == 0 ? 0 : (acceptanceSets - 1) / 2;
                ++relevantIndex;
            }
            List preRankings = Arrays.stream(maximalRanks).mapToObj(i -> IntStream.rangeClosed(0, i).boxed().collect(Collectors.toList())).collect(Collectors.toList());
            List rankings = Lists.cartesianProduct(preRankings);
            GeneralizedRabinAcceptance.RabinPair[] rankingPairs = new GeneralizedRabinAcceptance.RabinPair[rankings.size()];
            Arrays.setAll(rankingPairs, i -> builder.add(subset.size()));
            return new ActiveSet(subset, rankings, rankingPairs);
        }

        GeneralizedRabinAcceptance.RabinPair getPairForRanking(int rankingIndex) {
            return this.rankingPairs[rankingIndex];
        }
    }
}

