/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sudoku;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.TikzFontDistortion;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.sudoku.ISudoku;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.tikz.UGraphicTikz;

public class GraphicsSudoku {
    private final ISudoku sudoku;
    private final UFont numberFont = UFont.sansSerif(20).bold();
    private final UFont font = UFont.sansSerif(11);
    private final int xOffset = 5;
    private final int yOffset = 5;
    private final int cellWidth = 30;
    private final int cellHeight = 32;
    private final int numberxOffset = 10;
    private final int numberyOffset = 5;
    private final int textTotalHeight = 50;
    private final int boldWidth = 3;
    private final int sudoHeight = 301;
    private final int sudoWidth = 283;

    public GraphicsSudoku(ISudoku sudoku) {
        this.sudoku = sudoku;
    }

    public ImageData writeImageEps(OutputStream os) throws IOException {
        UGraphicEps ug = new UGraphicEps((ColorMapper)new ColorMapperIdentity(), EpsStrategy.WITH_MACRO_AND_TEXT);
        this.drawInternal(ug);
        os.write(ug.getEPSCode().getBytes());
        return ImageDataSimple.ok();
    }

    public ImageData writeImageSvg(OutputStream os) throws IOException {
        UGraphicSvg ug = new UGraphicSvg(true, (Dimension2D)new Dimension2DDouble(0.0, 0.0), (ColorMapper)new ColorMapperIdentity(), (String)null, false, 1.0, null, null, 0L);
        this.drawInternal(ug);
        ug.createXml(os, null);
        return ImageDataSimple.ok();
    }

    public ImageData writeImageLatex(OutputStream os, FileFormat fileFormat) throws IOException {
        UGraphicTikz ug = new UGraphicTikz(new ColorMapperIdentity(), 1.0, fileFormat == FileFormat.LATEX, TikzFontDistortion.getDefault());
        this.drawInternal(ug);
        ug.createTikz(os);
        return ImageDataSimple.ok();
    }

    public ImageData writeImagePng(OutputStream os) throws IOException {
        EmptyImageBuilder builder = new EmptyImageBuilder(283, 351, Color.WHITE);
        BufferedImage im = builder.getBufferedImage();
        Graphics2D g3d = builder.getGraphics2D();
        UGraphicG2d ug = new UGraphicG2d(new ColorMapperIdentity(), g3d, 1.0);
        this.drawInternal(ug);
        g3d.dispose();
        PngIO.write((RenderedImage)im, os, 96);
        return new ImageDataSimple(im.getWidth(), im.getHeight());
    }

    private void drawInternal(UGraphic ug) {
        int w;
        boolean bold;
        int i;
        ug = ug.apply(new UTranslate(5.0, 5.0));
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 9; ++y) {
                int num = this.sudoku.getGiven(x, y);
                if (num <= 0) continue;
                TextBlock text = Display.create("" + num).create(FontConfiguration.blackBlueTrue(this.numberFont), HorizontalAlignment.CENTER, new SpriteContainerEmpty());
                text.drawU(ug.apply(new UTranslate(10 + x * 30, 5 + y * 32)));
            }
        }
        ug = ug.apply(new UChangeBackColor(HtmlColorUtils.BLACK)).apply(new UChangeColor(null));
        for (i = 0; i < 10; ++i) {
            bold = i % 3 == 0;
            w = bold ? 3 : 1;
            ug.apply(new UTranslate(0.0, i * 32)).draw(new URectangle(273.0, w));
        }
        for (i = 0; i < 10; ++i) {
            bold = i % 3 == 0;
            w = bold ? 3 : 1;
            ug.apply(new UTranslate(i * 30, 0.0)).draw(new URectangle(w, 291.0));
        }
        ug = ug.apply(new UTranslate(0.0, 301.0));
        ArrayList<String> texts = new ArrayList<String>();
        texts.add("http://plantuml.com");
        texts.add("Seed " + Long.toString(this.sudoku.getSeed(), 36));
        texts.add("Difficulty " + this.sudoku.getRatting());
        TextBlock textBlock = Display.create(texts).create(FontConfiguration.blackBlueTrue(this.font), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        textBlock.drawU(ug);
    }
}

