/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.sprite;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.sprite.Sprite;

public class SpriteImage
implements Sprite {
    private final UImage img;

    public SpriteImage(BufferedImage img) {
        this.img = new UImage(img);
    }

    @Override
    public TextBlock asTextBlock(final HtmlColor color, final double scale) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                if (color == null) {
                    ug.draw(SpriteImage.this.img.scale(scale));
                } else {
                    ug.draw(SpriteImage.this.img.muteColor(((HtmlColorSimple)color).getColor999()).scale(scale));
                }
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble((double)SpriteImage.this.img.getWidth() * scale, (double)SpriteImage.this.img.getHeight() * scale);
            }
        };
    }

    public static Sprite fromInternal(String name) {
        if (name.endsWith(".png")) {
            throw new IllegalArgumentException();
        }
        InputStream is = SpriteImage.getInternalSprite(name + ".png");
        if (is == null) {
            return null;
        }
        try {
            return new SpriteImage(ImageIO.read(is));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream getInternalSprite(String inner) {
        String path = "/sprites/" + inner;
        InputStream is = SpriteImage.class.getResourceAsStream(path);
        return is;
    }
}

